package kom.itbeankit.common.vcr;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.util.*;
import symantec.itools.util.Timer;


/**
This Bean contains a VCR-panel with various Buttons to control other Beans
by firing ItBeanFrameEvents. It includes the Symantec-Timer-Component.
Pressing a button starts the Timer with or without repeat depending on which
button was pressed.
Designed with Visual Caf.
@author Alexander Kempf
@version 0.0 1998/06/30

@version 0.1 27.07.1998, A. El saddik, Alexander Kempf
add BackwardsButton
add userComplexityLevel
@version 0.2 27.07.1998, A. El saddik, Ramon Faja
add numberOfComplexityLevel

@version 0.3 18.08.1998, A. El saddik, Amir Ghavam
Bean + VisualCafe Project + Button.Setenabled(Boolean)

@version 0.4 24.08.1998, Amir Ghavam
ClkEvent is added
*/

public class ControlButtonPanel extends java.awt.Container
{
    protected boolean risingClkEdge = false;
    public void fireClkEvent(boolean risingEdge)
    {
            for(int i=0; i<clkListeners.size();i++){
                ClkListener cl = (ClkListener)clkListeners.elementAt(i);
                cl.clkReceived(new ClkEvent(this,risingEdge));
            }
    }
    public synchronized void removeClkListener (ClkListener l)
    {
        clkListeners.removeElement(l);
    }
    public synchronized void addClkListener (ClkListener l)
    {
        clkListeners.addElement(l);
    }
    protected Vector clkListeners = new Vector();

    /**
    This constructor creates an ControlButtonPanel-object with 4 buttons:
    playButton, stepButton, stopButton, hideButton
    Also a timer is instantiated.
    Most of the constructor was generated by Visual Caf
    */

	public ControlButtonPanel()
	{
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setSize(462,40);
		panel = new java.awt.Panel();
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		panel.setLayout(gridBagLayout);
		panel.setBounds(0,0,462,40);
		add("Center", panel);
		stopButton = new java.awt.Button();
		stopButton.setLabel("stop");
		stopButton.setBounds(1,0,54,40);
		stopButton.setBackground(new Color(12632256));
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(stopButton, gbc);
		panel.add(stopButton);
		stopButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		backwardsButton = new java.awt.Button();
		backwardsButton.setActionCommand("backwards");
		backwardsButton.setLabel("<< step");
		backwardsButton.setBounds(55,0,71,40);
		backwardsButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(backwardsButton, gbc);
		panel.add(backwardsButton);
		backwardsButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		stepButton = new java.awt.Button();
		stepButton.setActionCommand("forwards");
		stepButton.setLabel("step >>");
		stepButton.setBounds(126,0,71,40);
		stepButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 2;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(stepButton, gbc);
		panel.add(stepButton);
		stepButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		playButton = new java.awt.Button();
		playButton.setLabel("play");
		playButton.setBounds(197,0,52,40);
		playButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 3;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(playButton, gbc);
		panel.add(playButton);
		playButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		hideButton = new java.awt.Button();
		hideButton.setLabel("hide");
		hideButton.setBounds(249,0,54,40);
		hideButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 4;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(hideButton, gbc);
		panel.add(hideButton);
		hideButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		userComplexityLevelLabel = new java.awt.Label("Level: ",Label.CENTER);
		userComplexityLevelLabel.setBounds(308,0,65,40);
		userComplexityLevelLabel.setBackground(new Color(16777215));
		gbc = new GridBagConstraints();
		gbc.gridx = 5;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,5,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(userComplexityLevelLabel, gbc);
		panel.add(userComplexityLevelLabel);
		levelDownButton = new java.awt.Button();
		levelDownButton.setActionCommand("levelDown");
		levelDownButton.setLabel("<<");
		levelDownButton.setBounds(373,0,44,40);
		levelDownButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 6;
		gbc.gridy = 0;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(levelDownButton, gbc);
		panel.add(levelDownButton);
		levelDownButton.setEnabled(false);
		levelDownButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		levelUpButton = new java.awt.Button();
		levelUpButton.setActionCommand("levelUp");
		levelUpButton.setLabel(">>");
		levelUpButton.setBounds(417,0,44,40);
		levelUpButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 7;
		gbc.gridy = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(levelUpButton, gbc);
		panel.add(levelUpButton);
		levelUpButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		timer1 = new symantec.itools.util.Timer(1,true);
		timer1.start();
		//$$ timer1.move(108,276);
		//}}
        theComplexityLevel=1;
        timer1 = new symantec.itools.util.Timer(timerDelay,true);
		userComplexityLevelLabel.setText(userComplexityLevelLabel.getText()+ theComplexityLevel);
		//userComplexityLevelLabel.setText("Level: " + theComplexityLevel, Label.CENTER);
        // new Integer(theComplexityLevel).toString()
		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		playButton.addActionListener(lSymAction);
		stopButton.addActionListener(lSymAction);
		stepButton.addActionListener(lSymAction);
		backwardsButton.addActionListener(lSymAction);
		hideButton.addActionListener(lSymAction);
		levelDownButton.addActionListener(lSymAction);
		levelUpButton.addActionListener(lSymAction);
		//}}
		timer1.addActionListener(lSymAction);
	}
	//{{DECLARE_CONTROLS
	java.awt.Panel panel;
	java.awt.Button stopButton;
	java.awt.Button backwardsButton;
	java.awt.Button stepButton;
	java.awt.Button playButton;
	java.awt.Button hideButton;
	java.awt.Label userComplexityLevelLabel;
	java.awt.Button levelDownButton;
	java.awt.Button levelUpButton;
	symantec.itools.util.Timer timer1;
	//}}
    private int theComplexityLevel=1;
    private int numberOfComplexityLevels=10;
	private Vector actionListeners = new Vector();
	private boolean play = false;
	public int timerDelay = 1000;

    public final static int STOP_BUTTON = 7000;
    public final static int BACKWARD_BUTTON = 7001;
    public final static int FORWARD_BUTTON = 7002;
    public final static int PLAY_BUTTON = 7003;
    public final static int HIDE_BUTTON = 7004;

/**
This class was generated by Visual Caf.
It's an inner class that plays the role of an ActionEventAdapter.
Any ActionEvent caused by VCR-buttons or the timer will invoke a
corresponding method.
*/

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == playButton)
				playButton_ActionPerformed(event);
			else if (object == stopButton)
				stopButton_ActionPerformed(event);
			else if (object == stepButton)
				stepButton_ActionPerformed(event);
				else if (object == backwardsButton)
				backwardsButton_ActionPerformed(event);
			else if (object == hideButton)
				hideButton_ActionPerformed(event);
			else if (object == levelDownButton)
				levelDownButton_ActionPerformed(event);
			else if (object == levelUpButton)
				levelUpButton_ActionPerformed(event);
			else if (object == timer1)
				timer1_ActionPerformed(event);
		}
	}



//	The main-method was generated by Visual Caf

	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new ControlButtonPanel());
			}
		}

		new DriverFrame().show();
	}







/**
This method is invoked if the playButton sources an ActionEvent.
It sets the timer to repeat and invokes the timer's resume()-method.
It sets the ActionCommand to "play".
*/

	void playButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.


		if(play) {
		    playButton.setLabel("play");
		    playButton.setActionCommand("pause");
		    timer1.stop();
		    fireActionEvent(playButton.getActionCommand());
		}
		else {
		    playButton.setLabel("pause");
		    playButton.setActionCommand("play");
			try {
		        timer1.setActionCommand(playButton.getActionCommand());
		        fireActionEvent(playButton.getActionCommand());
		        }
		    catch (PropertyVetoException exc) {};
		//{{CONNECTION
		// Set whether the Timer repeats...
		    try
		    {
			    timer1.setRepeat(true);
		    }
		    catch(java.beans.PropertyVetoException e) {}
		//}}
		//{{CONNECTION
		// Resume Timer
		    timer1.start();
		//}}
		}
		play = !play;
	}

/**
This method is invoked if the stopButton sources an ActionEvent.
It invokes the timer's stop()-method.
It sets the ActionCommand to "stop".
*/

	void stopButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		if(play) playButton.setLabel("play");
		play = false;
		//{{CONNECTION
		// Stop Timer
		timer1.stop();
		//}}
		fireActionEvent(stopButton.getActionCommand());
	}

/**
This method is invoked if the stepButton sources an ActionEvent.
It sets the timer to not repeat and invokes the timer's start()-method.
It sets the ActionCommand to "forwards".
*/
	void stepButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
	    try {timer1.setActionCommand(stepButton.getActionCommand());}
		catch (PropertyVetoException exc) {};

		if(play) playButton.setLabel("play");
		play = false;
		//{{CONNECTION
		// Set whether the Timer repeats...
		try
		{
			timer1.setRepeat(false);
		}
		catch(java.beans.PropertyVetoException e) {}
		//}}

		//{{CONNECTION
		// Resume Timer
		timer1.start();
		//}}
        fireActionEvent(stepButton.getActionCommand());
	}

//////////
/**
This method is invoked if the backwardsButton sources an ActionEvent.
It sets the timer to not repeat and invokes the timer's start()-method.
It sets the ActionCommand to "forwards".
*/
	void backwardsButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
	    try {timer1.setActionCommand(backwardsButton.getActionCommand());}
		catch (PropertyVetoException exc) {};

		if(play) playButton.setLabel("play");
		play = false;

		//{{CONNECTION
		// Set whether the Timer repeats...
		try
		{
			timer1.setRepeat(false);
		}
		catch(java.beans.PropertyVetoException e) {}
		//}}

		//{{CONNECTION
		// Resume Timer
		timer1.start();
		//}}
        fireActionEvent(backwardsButton.getActionCommand());
	}

/**
This method is invoked if the hideButton sources an ActionEvent.
It invokes the timer's pause()-method.
It sets the ActionCommand to "hide".
*/

	void hideButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
		fireActionEvent(hideButton.getActionCommand());

	}

    public void setNumberOfComplexityLevels(int nc) {
      numberOfComplexityLevels = nc;
      if ( numberOfComplexityLevels == 1){
        levelDownButton.setEnabled(false);
        levelUpButton.setEnabled(false);
      }
    }

     public int getNumberOfComplexityLevels() {
      return numberOfComplexityLevels;
    }


/**
This method is invoked if the levelDownButton sources an ActionEvent.
It sets the ActionCommand to "levelDown".
*/
    void levelDownButton_ActionPerformed(java.awt.event.ActionEvent event)
    {
      if (theComplexityLevel == 2) {
        levelDownButton.setEnabled(false);
        levelUpButton.setEnabled(true);
        theComplexityLevel--;
      }
      else if ((theComplexityLevel <= (numberOfComplexityLevels)) & (theComplexityLevel>2)){
        levelUpButton.setEnabled(true);
        theComplexityLevel--;
      }
      else if (theComplexityLevel == 1) {
        levelDownButton.setEnabled(false);

      }
	  fireActionEvent(levelDownButton.getActionCommand());
	  //theComplexityLevel--;
	  userComplexityLevelLabel.setText("Level: " + theComplexityLevel);
	  userComplexityLevelLabel.setAlignment(Label.CENTER);
	}

/**
This method is invoked if the levelDownButton sources an ActionEvent.
It sets the ActionCommand to "levelDown".
*/
    void levelUpButton_ActionPerformed(java.awt.event.ActionEvent event)
    {
      if (theComplexityLevel == (numberOfComplexityLevels - 1)) {
        levelUpButton.setEnabled(false);
        levelDownButton.setEnabled(true);
        theComplexityLevel++;
      }
      else if ((theComplexityLevel >= 1) & (theComplexityLevel < numberOfComplexityLevels )){
        levelDownButton.setEnabled(true);
        theComplexityLevel++;
      }
      else if (theComplexityLevel == numberOfComplexityLevels) {
        levelUpButton.setEnabled(false);
      }
      fireActionEvent(levelUpButton.getActionCommand());
	  //theComplexityLevel++;
	  userComplexityLevelLabel.setText("Level: " + theComplexityLevel);
	}

/**
This method is invoked if the timer sources an ActionEvent.
It just invokes the fireActionEvent()-method.
*/
	void timer1_ActionPerformed(java.awt.event.ActionEvent event) {
	    fireActionEvent(timer1.getActionCommand());
        fireClkEvent(true);
        fireClkEvent(false);
        //risingClkEdge = !risingClkEdge;
	}

	/**
	This method adds an ActionListener to the list.
	*/

    public synchronized void addActionListener (ActionListener l) {
        actionListeners.addElement(l);
    }

    /**
    This method removes an ActionListener from the list.
    */

    public synchronized void removeActionListener (ActionListener l) {
        actionListeners.removeElement(l);
    }

    /**
    This method calls the actionPerformed()-method of all Listeners.
    It uses an ActionEvent as an argument.
    */

	public void fireActionEvent(ActionEvent evt) {
	    String actionCommand = evt.getActionCommand();
	    for(int i=0; i < actionListeners.size(); i++) {
	        ActionListener il = (ActionListener)actionListeners.elementAt(i);
	        il.actionPerformed(new ActionEvent(this,ActionEvent.ACTION_PERFORMED,actionCommand));
	    }

	}

	/**
    This method calls the actionPerformed()-method of all Listeners.
    It uses a String as an argument.
    */

	public void fireActionEvent(String actionCommand) {
	    for(int i=0; i < actionListeners.size(); i++) {
	        ActionListener il = (ActionListener)actionListeners.elementAt(i);
	        il.actionPerformed(new ActionEvent(this,ActionEvent.ACTION_PERFORMED,actionCommand));
	    }

	}

	/**
	This method gives back the timerDelay.
	*/

	public int getTimerDelay() {
	    return timerDelay;
	}

	/**
	This method sets the timerDelay.
	*/

	public void setTimerDelay(int delayTime) {
	    timerDelay = delayTime;
	    try {
	        timer1.setDelay(timerDelay);
	    }
	    catch (PropertyVetoException exc) {};
	}



    public void setComplexityLevel(int level) {
	    theComplexityLevel = level;
	}

    public int getComplexityLevel() {
	    return theComplexityLevel;
	}

	/**
	This method enables/disables the buttons and the
	timer except the hide and level control buttons.
	@param flag true to enable the buttons and the timer
	*/
	public void setEnabled(boolean flag) {
	    if (flag) this.timer1.resume();
	    else this.timer1.pause();
    	this.stopButton.setEnabled(flag);
	    this.stepButton.setEnabled(flag);
	    this.backwardsButton.setEnabled(flag);
	    this.playButton.setEnabled(flag);
	}


	/**
	This method enables/disables the buttons one wishes and the
	timer except the hide and level control buttons.

	@param int button number as follow:
	STOP_BUTTON, BACKWARD_BUTTON, FORWARD_BUTTON, PLAY_BUTTON, HIDE_BUTTON
	@param flag true to enable the buttons and the timer

	*/
	public void setEnabled(int buttonNr, boolean flag) {
	    switch (buttonNr) {
	        case STOP_BUTTON:
	            this.stopButton.setEnabled(flag);
	            break;
	        case BACKWARD_BUTTON:
	            this.backwardsButton.setEnabled(flag);
	            break;
	        case FORWARD_BUTTON:
	            this.stepButton.setEnabled(flag);
	            break;
	        case PLAY_BUTTON:
	            this.playButton.setEnabled(flag);
	            break;
	        case HIDE_BUTTON:
	            this.hideButton.setEnabled(flag);
	            break;
	        default:
	    }
	}

}